﻿using System;

namespace VA.PPMS.IWS.Common
{
    public class DasMessage
    {
        public const string VaPpmsIdentifier = "VA_PPMS";
        public const string VaNetworkIdentifier = "VA_Provider";
        public const string TriWestIdentifier = "CCN_TRW_National";

        private const string Delimiter = "||";

        public string ConversationId { get; set; }

        public string SenderId { get; set; }

        public string ReceiverId { get; set; }

        public string TransactionId { get; set; }

        public string Content { get; set; }

        public bool IsValid => ReceiverId == VaPpmsIdentifier
                               && !string.IsNullOrEmpty(ConversationId)
                               && !string.IsNullOrEmpty(SenderId)
                               && !string.IsNullOrEmpty(TransactionId);

        public bool IsVaNetwork => !string.IsNullOrEmpty(SenderId) && SenderId.Contains(VaNetworkIdentifier);
        public bool IsVaReceiver => !string.IsNullOrEmpty(ReceiverId) && ReceiverId.Contains(VaNetworkIdentifier);

        public DasMessage()
        {
        }

        public DasMessage(string conversationId, string senderId, string receiverId, string transactionId)
        {
            ConversationId = conversationId;
            SenderId = senderId;
            ReceiverId = receiverId;
            TransactionId = transactionId;
        }

        public DasMessage(string conversationId, string senderId, string receiverId, string transactionId, string content)
        {
            ConversationId = conversationId;
            SenderId = senderId;
            ReceiverId = receiverId;
            TransactionId = transactionId;
            Content = content;
        }

        public DasMessage(string message)
        {
            ParseMessage(message);
        }

        public override string ToString()
        {
            return $"{ConversationId}{Delimiter}{SenderId}{Delimiter}{ReceiverId}{Delimiter}{TransactionId}{Delimiter}{Content}";
        }

        private void ParseMessage(string message)
        {
            Reset();

            var items = message.Split(new[] { Delimiter }, StringSplitOptions.None);

            if (items.Length == 5)
            {
                ConversationId = items[0];
                SenderId = items[1];
                ReceiverId = items[2];
                TransactionId = items[3];
                Content = items[4];
            }
        }

        private void Reset()
        {
            ConversationId = string.Empty;
            SenderId = string.Empty;
            ReceiverId = string.Empty;
            TransactionId = string.Empty;
            Content = string.Empty;
        }
    }
}